% ex6_5ekf.m 
% section 6.5
% estimation of Wiener model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% x(t+1) = A*x(t)+B*u(t)+w(t)
%   y(t) = beta1*x(t)+beta2*x(t)^2+beta3*x(t)^3+v(t)
clear

N=1000;
a=0.9;
b=1;
n=4;
beta1=1;
beta2=0.05;
beta3=-0.01;
q=0.36;
r=0.25;
t=0:1:N;
x=zeros(4,N+1);
v=sqrt(r)*randn(1,N+1);
w=sqrt(q)*randn(1,N+1);
y=zeros(1,N+1);
u=2.0*randn(1,N+1);
x(1,1)=0;
x(2,1)=beta1;
x(3,1)=beta2;
x(4,1)=beta3;
% data generation
for i=1:N
x(1,i+1)= a*x(1,i) + b*u(1,i)+w(1,i);
x(2,i+1)=beta1;
x(3,i+1)=beta2;
x(4,i+1)=beta3;
z=x(1,i);
tau= (beta1 + (beta2+beta3*z)*z)*z;
y(1,i)=tau + v(1,i);
end
z=x(1,N+1);
tau= (beta1 + (beta2+beta3*z)*z)*z;
y(1,N+1)=x(1,N+1)+v(1,N+1);
%
% EKF
H=[1 0 0 0];
F=[a  0  0  0;
   0  1  0  0;
   0  0  1  0
   0  0  0  1];
q1=0.0;
q2=0.0;
q3=0.0;
Q=[q 0 0 0;
   0 q1 0 0;
   0 0 q2 0
   0 0 0 q3];
xep=zeros(n,N+1);    % prediction xe_{t/t-1}
xef=zeros(n,N+1);    % filtering  xe_{t/t}
Pep=zeros(n,n,N+1);  % covariance of prediction P_{t/t-1}
Pef=zeros(n,n,N+1);  % covariance of filtering P_{t/t}
Pep(:,:,1)=[4 0 0 0;
            0 1 0 0;
            0 0 1 0
            0 0 0 1]; % initial covariance of prediction
K=zeros(n,1,N+1);
xeff=zeros(1,N+1);
xep(:,1)= [0 0 0 0]';
for i=1:N+1
z=xep(1,i);
h1=xep(2,i)+2*xep(3,i)*z+3*xep(4,i)*z*z;
h2=z;
h3=h2*z;
h4=h3*z;
H=[h1 h2 h3 h4];
hx=xep(2,i)*h2+xep(3,i)*h3+xep(4,i)*h4;
K(:,:,i)=Pep(:,:,i)*H'/(H*Pep(:,:,i)*H'+r);  % kalman gain
xef(:,i)=xep(:,i) + K(:,:,i)*(y(1,i)-hx); 
xeff(1,i)=xef(1,i);                % for figure
% Pef(:,:,i)=inv(inv(Pep(:,:,i))+H'*H/r);  % covariance of filtering
Pef(:,:,i)=Pep(:,:,i)-K(:,:,i)*H*Pep(:,:,i);
Pep(:,:,i+1)=F*Pef(:,:,i)*F' + Q;   % covarinace of prediction
xep(:,i+1)=F*xef(:,i) + [b*u(1,i) 0 0 0]';
end

for i=1:N+1
RMSE(1,i)=sqrt((x(1,i)-xeff(1,i))^2);
end
RMSEekf=sum(RMSE)/N

figure(1)
plot(t,x(1,1:N+1),'r',t,y(1,1:N+1),'gx-',t,xef(1,1:N+1),'bo-')
xlabel('Number of steps t')
title('Filtering by EKF')
axis([0,N,-15,15]);
grid
legend('True x_t','Observation y_t','Filtered estimate x_{t|t}')

figure(2)
plot(t,x(2,1:N+1),'r',t,xef(2,1:N+1),'b-','LineWidth',1.5)
xlabel('Number of steps t')
title('Fig. 6.6b: Estimation of \beta_1')
axis([0,N,-1,2]);
grid
legend('True beta_1=1.0','Estimate by EKF')
hold on

figure(3)
plot(t,x(3,1:N+1),'r',t,xef(3,1:N+1),'b-','LineWidth',1.5)
xlabel('Number of steps t')
title('Fig. 6.7b: Estimation of \beta_2')
axis([0,N,-1,1]);
grid
legend('True \beta_2=0.05','Estimate by EKF')
hold on

figure(4)
plot(t,x(4,1:N+1),'r',t,xef(4,1:N+1),'b-','LineWidth',1.5)
xlabel('Number of steps t')
title('Fig. 6xb: Estimation of \beta_3')
axis([0,N,-1,1]);
grid
legend('True \beta_3=-0.01','Estimate by EKF')
hold on

figure(5)
plot(t,RMSE,'b-','LineWidth',1.5)
axis([0 N 0 10])
grid
xlabel('Number of steps t')
title('Fig. 6.8b: State estimation error by EKF')
ylabel('E_t')
legend('State estimation error by EKF')
hold on



